/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.imageio.ImageIO;

public class PgbDirectVideoOutput
extends PgbVideoOutput {
    Graphics graph;
    MemoryImageSource screenMISrc;
    Image screenMImg;
    int[] screenMemory;
    MemoryImageSource borderMISrc;
    Image borderMImg;
    int[] borderMemory;

    public void setGraphics() {
        this.graph = this.getGraphics();
    }

    public PgbDirectVideoOutput(PgbVideo pgbVideo, Applet applet) {
        super(pgbVideo);
        System.out.println("applet video!");
        this.screenMemory = new int[23040];
        this.screenMISrc = new MemoryImageSource(160, 144, this.screenMemory, 0, 160);
        this.screenMISrc.setAnimated(true);
        this.screenMImg = applet.createImage(this.screenMISrc);
    }

    public PgbDirectVideoOutput(PgbVideo pgbVideo) {
        super(pgbVideo);
        this.screenMemory = new int[23040];
        this.screenMISrc = new MemoryImageSource(160, 144, this.screenMemory, 0, 160);
        this.screenMISrc.setAnimated(true);
        this.screenMImg = this.createImage(this.screenMISrc);
        this.borderMemory = new int[57344];
        this.borderMISrc = new MemoryImageSource(256, 224, this.borderMemory, 0, 256);
        this.borderMISrc.setAnimated(true);
        this.borderMImg = this.createImage(this.borderMISrc);
    }

    public void reset() {
    }

    public void hblank(int n) {
        int n2 = n * 160;
        for (int i = 0; i < 160; ++i) {
            this.screenMemory[n2 + i] = this.video.getScreenColor(this.video.getScreenMemory(n * 160 + i));
        }
    }

    public void vblank() {
        this.screenMISrc.newPixels();
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        if (PgbSettings.sgbborder) {
            graphics.drawImage(this.screenMImg, 48 * PgbSettings.lcdsize, 40 * PgbSettings.lcdsize, 160 * PgbSettings.lcdsize, 144 * PgbSettings.lcdsize, this);
            graphics.drawImage(this.borderMImg, 0 * PgbSettings.lcdsize, 0 * PgbSettings.lcdsize, 256 * PgbSettings.lcdsize, 40 * PgbSettings.lcdsize, 0, 0, 256, 40, this);
            graphics.drawImage(this.borderMImg, 0 * PgbSettings.lcdsize, 40 * PgbSettings.lcdsize, 48 * PgbSettings.lcdsize, 184 * PgbSettings.lcdsize, 0, 40, 48, 184, this);
            graphics.drawImage(this.borderMImg, 208 * PgbSettings.lcdsize, 40 * PgbSettings.lcdsize, 256 * PgbSettings.lcdsize, 184 * PgbSettings.lcdsize, 208, 40, 256, 184, this);
            graphics.drawImage(this.borderMImg, 0 * PgbSettings.lcdsize, 184 * PgbSettings.lcdsize, 256 * PgbSettings.lcdsize, 224 * PgbSettings.lcdsize, 0, 184, 256, 224, this);
        } else {
            graphics.drawImage(this.screenMImg, 0, 0, 160 * PgbSettings.lcdsize, 144 * PgbSettings.lcdsize, this);
        }
    }

    public void makeScreenshot() {
        Date date = new Date();
        long l = date.getTime();
        int n = this.screenMImg.getWidth(this);
        int n2 = this.screenMImg.getHeight(this);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(this.screenMImg, 0, 0, null);
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", new File("AEPgb-" + l + ".png"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

